<?php
/**
 * Rotinas de desinstalação do plugin CPW Consentimento.
 * Este arquivo é executado quando o plugin é excluído pelo WordPress.
 *
 * @package CPW_Consentimento
 */

// Se a desinstalação não foi chamada pelo WordPress, encerra a execução
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

global $wpdb;

// Remove a tabela de registros de consentimento
$table_name = $wpdb->prefix . 'cpw_consent_logs';
$wpdb->query( "DROP TABLE IF EXISTS {$table_name}" );

// Remove todas as opções do plugin
delete_option( 'cpw_general_options' );
delete_option( 'cpw_google_options' );
delete_option( 'cpw_banner_options' );
delete_option( 'cpw_privacy_options' );
delete_option( 'cpw_consentimento_db_version' );

// Remove transients
delete_transient( 'cpw_consentimento_cache' );
