<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$general_options = get_option( 'cpw_general_options', array() );
$banner_options  = get_option( 'cpw_banner_options', array() );
$privacy_options = get_option( 'cpw_privacy_options', array() );

// Não exibe se o plugin estiver desativado
if ( empty( $general_options['enable_plugin'] ) ) {
    return;
}

$position     = ! empty( $banner_options['banner_position'] ) ? $banner_options['banner_position'] : 'bottom';
$bg_color     = ! empty( $banner_options['banner_bg_color'] ) ? $banner_options['banner_bg_color'] : '#ffffff';
$text_color   = ! empty( $banner_options['banner_text_color'] ) ? $banner_options['banner_text_color'] : '#333333';
$accept_color = ! empty( $banner_options['banner_accept_btn_color'] ) ? $banner_options['banner_accept_btn_color'] : '#0073aa';
$decline_color = ! empty( $banner_options['banner_decline_btn_color'] ) ? $banner_options['banner_decline_btn_color'] : '#666666';
$title        = ! empty( $banner_options['banner_title'] ) ? $banner_options['banner_title'] : __( 'Sua privacidade é importante para nós', 'cpw-consentimento' );
$text         = ! empty( $banner_options['banner_text'] ) ? $banner_options['banner_text'] : __( 'Utilizamos cookies e tecnologias semelhantes para melhorar a sua experiência em nosso site, personalizar conteúdo e anúncios, e analisar o tráfego. Ao clicar em "Aceitar todos", você concorda com o uso de cookies conforme nossa Política de Privacidade.', 'cpw-consentimento' );
$accept_text  = ! empty( $banner_options['accept_btn_text'] ) ? $banner_options['accept_btn_text'] : __( 'Aceitar todos', 'cpw-consentimento' );
$decline_text = ! empty( $banner_options['decline_btn_text'] ) ? $banner_options['decline_btn_text'] : __( 'Recusar', 'cpw-consentimento' );
$custom_text  = ! empty( $banner_options['customize_btn_text'] ) ? $banner_options['customize_btn_text'] : __( 'Personalizar', 'cpw-consentimento' );

$privacy_page_id  = ! empty( $privacy_options['privacy_page'] ) ? $privacy_options['privacy_page'] : 0;
$privacy_page_url = $privacy_page_id ? get_permalink( $privacy_page_id ) : '#';
?>

<!-- CPW Consentimento - Banner de Consentimento LGPD -->
<div id="cpw-consent-overlay"></div>

<div id="cpw-consent-banner"
     class="cpw-position-<?php echo esc_attr( $position ); ?>"
     style="background-color: <?php echo esc_attr( $bg_color ); ?>; color: <?php echo esc_attr( $text_color ); ?>;"
     role="dialog"
     aria-labelledby="cpw-banner-title"
     aria-describedby="cpw-banner-desc">

    <div class="cpw-banner-inner">
        <div class="cpw-banner-header">
            <h2 id="cpw-banner-title" class="cpw-banner-title"><?php echo esc_html( $title ); ?></h2>
        </div>

        <p id="cpw-banner-desc" class="cpw-banner-text">
            <?php echo wp_kses_post( $text ); ?>
            <?php if ( $privacy_page_id ) : ?>
                <a href="<?php echo esc_url( $privacy_page_url ); ?>" target="_blank" rel="noopener noreferrer">
                    <?php esc_html_e( 'Saiba mais', 'cpw-consentimento' ); ?>
                </a>
            <?php endif; ?>
        </p>

        <div class="cpw-banner-actions">
            <button id="cpw-btn-accept"
                    class="cpw-btn cpw-btn-accept"
                    style="background-color: <?php echo esc_attr( $accept_color ); ?>;"
                    aria-label="<?php esc_attr_e( 'Aceitar todos os cookies', 'cpw-consentimento' ); ?>">
                <?php echo esc_html( $accept_text ); ?>
            </button>

            <button id="cpw-btn-decline"
                    class="cpw-btn cpw-btn-decline"
                    style="background-color: <?php echo esc_attr( $decline_color ); ?>;"
                    aria-label="<?php esc_attr_e( 'Recusar cookies opcionais', 'cpw-consentimento' ); ?>">
                <?php echo esc_html( $decline_text ); ?>
            </button>

            <button id="cpw-btn-customize"
                    class="cpw-btn cpw-btn-customize"
                    style="color: <?php echo esc_attr( $text_color ); ?>; border-color: <?php echo esc_attr( $text_color ); ?>;"
                    aria-label="<?php esc_attr_e( 'Personalizar preferências de cookies', 'cpw-consentimento' ); ?>">
                <?php echo esc_html( $custom_text ); ?>
            </button>
        </div>
    </div>
</div>

<!-- Modal de Personalização de Cookies -->
<div id="cpw-customize-modal" role="dialog" aria-modal="true" aria-labelledby="cpw-modal-title">
    <div class="cpw-modal-header">
        <h3 id="cpw-modal-title" class="cpw-modal-title"><?php esc_html_e( 'Preferências de Privacidade', 'cpw-consentimento' ); ?></h3>
        <button id="cpw-modal-close" class="cpw-modal-close" aria-label="<?php esc_attr_e( 'Fechar', 'cpw-consentimento' ); ?>">&times;</button>
    </div>

    <div class="cpw-modal-body">
        <p><?php esc_html_e( 'Gerencie suas preferências de cookies. Você pode aceitar ou recusar diferentes categorias de cookies abaixo.', 'cpw-consentimento' ); ?></p>

        <!-- Cookies Essenciais -->
        <div class="cpw-cookie-category">
            <div class="cpw-cookie-category-header">
                <span class="cpw-cookie-category-title"><?php esc_html_e( 'Cookies Essenciais', 'cpw-consentimento' ); ?></span>
                <label class="cpw-toggle">
                    <input type="checkbox" checked disabled>
                    <span class="cpw-toggle-slider"></span>
                </label>
            </div>
            <div class="cpw-cookie-category-body">
                <p><?php esc_html_e( 'Esses cookies são necessários para o funcionamento básico do site e não podem ser desativados. Eles geralmente são definidos em resposta a ações realizadas por você, como definir suas preferências de privacidade, fazer login ou preencher formulários.', 'cpw-consentimento' ); ?></p>
            </div>
        </div>

        <!-- Cookies de Analytics -->
        <div class="cpw-cookie-category">
            <div class="cpw-cookie-category-header">
                <span class="cpw-cookie-category-title"><?php esc_html_e( 'Cookies de Analytics', 'cpw-consentimento' ); ?></span>
                <label class="cpw-toggle">
                    <input type="checkbox" id="cpw-toggle-analytics">
                    <span class="cpw-toggle-slider"></span>
                </label>
            </div>
            <div class="cpw-cookie-category-body">
                <p><?php esc_html_e( 'Esses cookies nos permitem contar visitas e fontes de tráfego para que possamos medir e melhorar o desempenho do nosso site. Eles nos ajudam a saber quais páginas são mais e menos populares e a ver como os visitantes se movem pelo site.', 'cpw-consentimento' ); ?></p>
                <p><strong><?php esc_html_e( 'Cookies utilizados:', 'cpw-consentimento' ); ?></strong> _ga, _gid, _gat (Google Analytics)</p>
            </div>
        </div>

        <!-- Cookies de Publicidade -->
        <div class="cpw-cookie-category">
            <div class="cpw-cookie-category-header">
                <span class="cpw-cookie-category-title"><?php esc_html_e( 'Cookies de Publicidade', 'cpw-consentimento' ); ?></span>
                <label class="cpw-toggle">
                    <input type="checkbox" id="cpw-toggle-advertising">
                    <span class="cpw-toggle-slider"></span>
                </label>
            </div>
            <div class="cpw-cookie-category-body">
                <p><?php esc_html_e( 'Esses cookies podem ser definidos por nossos parceiros de publicidade. Eles podem ser usados por essas empresas para criar um perfil de seus interesses e mostrar anúncios relevantes em outros sites.', 'cpw-consentimento' ); ?></p>
                <p><strong><?php esc_html_e( 'Cookies utilizados:', 'cpw-consentimento' ); ?></strong> _gcl_au, IDE (Google Ads)</p>
            </div>
        </div>

        <!-- Cookies de Personalização -->
        <div class="cpw-cookie-category">
            <div class="cpw-cookie-category-header">
                <span class="cpw-cookie-category-title"><?php esc_html_e( 'Cookies de Personalização', 'cpw-consentimento' ); ?></span>
                <label class="cpw-toggle">
                    <input type="checkbox" id="cpw-toggle-personalization">
                    <span class="cpw-toggle-slider"></span>
                </label>
            </div>
            <div class="cpw-cookie-category-body">
                <p><?php esc_html_e( 'Esses cookies permitem que o site forneça funcionalidade e personalização aprimoradas. Eles podem ser definidos por nós ou por provedores terceiros cujos serviços adicionamos às nossas páginas.', 'cpw-consentimento' ); ?></p>
            </div>
        </div>
    </div>

    <div class="cpw-modal-footer">
        <button id="cpw-btn-save-preferences" class="cpw-btn cpw-btn-decline">
            <?php esc_html_e( 'Salvar Preferências', 'cpw-consentimento' ); ?>
        </button>
        <button id="cpw-btn-accept-all-modal" class="cpw-btn cpw-btn-accept" style="background-color: <?php echo esc_attr( $accept_color ); ?>;">
            <?php echo esc_html( $accept_text ); ?>
        </button>
    </div>
</div>
<!-- /CPW Consentimento -->
