<?php
/**
 * Classe principal do plugin CPW Consentimento.
 *
 * @package CPW_Consentimento
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class CPW_Consentimento {

    protected $loader;
    protected $plugin_name;
    protected $version;

    public function __construct() {
        $this->version     = defined( 'CPW_CONSENTIMENTO_VERSION' ) ? CPW_CONSENTIMENTO_VERSION : '1.0.0';
        $this->plugin_name = 'cpw-consentimento';

        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
        $this->define_ajax_hooks();
    }

    // -------------------------------------------------------------------------
    // Carregamento de dependências
    // -------------------------------------------------------------------------

    private function load_dependencies() {
        require_once CPW_CONSENTIMENTO_PLUGIN_PATH . 'includes/class-cpw-loader.php';
        require_once CPW_CONSENTIMENTO_PLUGIN_PATH . 'admin/class-cpw-admin.php';
        require_once CPW_CONSENTIMENTO_PLUGIN_PATH . 'public/class-cpw-public.php';
        $this->loader = new CPW_Loader();
    }

    // -------------------------------------------------------------------------
    // Hooks do painel de administração
    // -------------------------------------------------------------------------

    private function define_admin_hooks() {
        $plugin_admin = new CPW_Admin( $this->get_plugin_name(), $this->get_version() );

        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_admin_menu' );
        $this->loader->add_action( 'admin_init', $plugin_admin, 'register_settings' );
    }

    // -------------------------------------------------------------------------
    // Hooks do frontend
    // -------------------------------------------------------------------------

    private function define_public_hooks() {
        $plugin_public = new CPW_Public( $this->get_plugin_name(), $this->get_version() );

        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

        // Google Consent Mode deve ser injetado o mais cedo possível no <head>
        $this->loader->add_action( 'wp_head', $plugin_public, 'inject_google_consent_mode', 1 );

        // GTM noscript logo após a abertura do <body>
        $this->loader->add_action( 'wp_body_open', $plugin_public, 'inject_gtm_body', 1 );

        // Banner no rodapé
        $this->loader->add_action( 'wp_footer', $plugin_public, 'add_consent_banner', 100 );
    }

    // -------------------------------------------------------------------------
    // Hooks AJAX
    // -------------------------------------------------------------------------

    private function define_ajax_hooks() {
        $plugin_public = new CPW_Public( $this->get_plugin_name(), $this->get_version() );

        // AJAX para usuários logados e não logados
        $this->loader->add_action( 'wp_ajax_cpw_log_consent', $plugin_public, 'ajax_log_consent' );
        $this->loader->add_action( 'wp_ajax_nopriv_cpw_log_consent', $plugin_public, 'ajax_log_consent' );
    }

    // -------------------------------------------------------------------------
    // Execução
    // -------------------------------------------------------------------------

    public function run() {
        $this->loader->run();
    }

    public function get_plugin_name() {
        return $this->plugin_name;
    }

    public function get_loader() {
        return $this->loader;
    }

    public function get_version() {
        return $this->version;
    }
}
