<?php
/**
 * Classe responsável pela ativação do plugin CPW Consentimento.
 *
 * @package CPW_Consentimento
 * @subpackage CPW_Consentimento/includes
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class CPW_Activator {

    /**
     * Executa as rotinas de ativação do plugin.
     * Cria a tabela de registros de consentimento no banco de dados.
     */
    public static function activate() {
        global $wpdb;

        $table_name      = $wpdb->prefix . 'cpw_consent_logs';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS {$table_name} (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            ip_address varchar(45) NOT NULL DEFAULT '',
            consent_status varchar(20) NOT NULL DEFAULT 'unknown',
            analytics_storage varchar(10) NOT NULL DEFAULT 'denied',
            ad_storage varchar(10) NOT NULL DEFAULT 'denied',
            functionality_storage varchar(10) NOT NULL DEFAULT 'granted',
            user_agent text NOT NULL,
            created_at datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
            PRIMARY KEY (id),
            KEY consent_status (consent_status),
            KEY created_at (created_at)
        ) {$charset_collate};";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta( $sql );

        // Armazena a versão do plugin
        update_option( 'cpw_consentimento_db_version', '1.0.0' );

        // Define opções padrão se não existirem
        if ( ! get_option( 'cpw_general_options' ) ) {
            update_option( 'cpw_general_options', array(
                'enable_plugin'  => 1,
                'cookie_duration' => 365,
                'cookie_name'    => 'cpw_consent_status',
                'block_scripts'  => 1,
            ) );
        }

        if ( ! get_option( 'cpw_google_options' ) ) {
            update_option( 'cpw_google_options', array(
                'gcm_enable'                  => 0,
                'gtm_id'                      => '',
                'ga4_id'                      => '',
                'gcm_default_analytics'       => 'denied',
                'gcm_default_ad_storage'      => 'denied',
                'gcm_default_ad_user_data'    => 'denied',
                'gcm_default_ad_personalization' => 'denied',
                'gcm_default_functionality'   => 'granted',
                'gcm_default_security'        => 'granted',
            ) );
        }

        if ( ! get_option( 'cpw_banner_options' ) ) {
            update_option( 'cpw_banner_options', array(
                'banner_title'            => 'Sua privacidade é importante para nós',
                'banner_text'             => 'Utilizamos cookies e tecnologias semelhantes para melhorar a sua experiência em nosso site, personalizar conteúdo e anúncios, e analisar o tráfego. Ao clicar em "Aceitar todos", você concorda com o uso de cookies conforme nossa Política de Privacidade.',
                'banner_position'         => 'bottom',
                'banner_bg_color'         => '#ffffff',
                'banner_text_color'       => '#333333',
                'banner_accept_btn_color' => '#0073aa',
                'banner_decline_btn_color' => '#666666',
                'accept_btn_text'         => 'Aceitar todos',
                'decline_btn_text'        => 'Recusar',
                'customize_btn_text'      => 'Personalizar',
            ) );
        }

        if ( ! get_option( 'cpw_privacy_options' ) ) {
            update_option( 'cpw_privacy_options', array(
                'privacy_page'       => 0,
                'dpo_name'           => '',
                'dpo_email'          => '',
                'company_name'       => '',
                'company_cnpj'       => '',
                'enable_consent_log' => 1,
            ) );
        }
    }
}
