<?php
/**
 * Plugin Name:       CPW Consentimento
 * Plugin URI:        https://criandoparaweb.com.br/plugins/wp/cpw-consentimento
 * Description:       Plugin para gerenciar o consentimento de cookies com integração ao Google Consent Mode v2, em total conformidade com a LGPD (Lei Geral de Proteção de Dados - Lei nº 13.709/2018).
 * Version:           1.0.0
 * Requires at least: 5.9
 * Requires PHP:      7.4
 * Author:            Criando para Web
 * Author URI:        https://criandoparaweb.com.br/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       cpw-consentimento
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Constantes do plugin
define( 'CPW_CONSENTIMENTO_VERSION', '1.0.0' );
define( 'CPW_CONSENTIMENTO_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'CPW_CONSENTIMENTO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'CPW_CONSENTIMENTO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

// Inclui as classes de ativação e desativação
require_once CPW_CONSENTIMENTO_PLUGIN_PATH . 'includes/class-cpw-activator.php';
require_once CPW_CONSENTIMENTO_PLUGIN_PATH . 'includes/class-cpw-deactivator.php';

// Hooks de ativação e desativação
register_activation_hook( __FILE__, array( 'CPW_Activator', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'CPW_Deactivator', 'deactivate' ) );

// Inclui a classe principal do plugin
require_once CPW_CONSENTIMENTO_PLUGIN_PATH . 'includes/class-cpw-consentimento.php';

/**
 * Inicia o plugin.
 */
function run_cpw_consentimento() {
    $plugin = new CPW_Consentimento();
    $plugin->run();
}

run_cpw_consentimento();
