<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap cpw-admin-wrap">
    <div class="cpw-admin-header">
        <h1><span class="dashicons dashicons-privacy"></span> <?php echo esc_html( get_admin_page_title() ); ?></h1>
        <p class="cpw-admin-subtitle"><?php esc_html_e( 'Gerencie o consentimento de cookies em conformidade com a LGPD e integrado ao Google Consent Mode v2.', 'cpw-consentimento' ); ?></p>
    </div>

    <?php settings_errors(); ?>

    <div class="cpw-admin-content">
        <div class="cpw-admin-main">
            <form method="post" action="options.php">
                <?php
                settings_fields( 'cpw_general_options' );
                do_settings_sections( 'cpw-consentimento' );
                submit_button( __( 'Salvar Configurações', 'cpw-consentimento' ) );
                ?>
            </form>
        </div>

        <div class="cpw-admin-sidebar">
            <div class="cpw-admin-box">
                <h3><?php esc_html_e( 'Status do Plugin', 'cpw-consentimento' ); ?></h3>
                <?php
                $general_options = get_option( 'cpw_general_options', array() );
                $google_options  = get_option( 'cpw_google_options', array() );
                $privacy_options = get_option( 'cpw_privacy_options', array() );
                $plugin_enabled  = ! empty( $general_options['enable_plugin'] );
                $gcm_enabled     = ! empty( $google_options['gcm_enable'] );
                $gtm_id          = ! empty( $google_options['gtm_id'] ) ? $google_options['gtm_id'] : '';
                $ga4_id          = ! empty( $google_options['ga4_id'] ) ? $google_options['ga4_id'] : '';
                $dpo_set         = ! empty( $privacy_options['dpo_email'] );
                ?>
                <ul class="cpw-status-list">
                    <li>
                        <span class="cpw-status-icon <?php echo $plugin_enabled ? 'cpw-status-ok' : 'cpw-status-warn'; ?>"></span>
                        <?php esc_html_e( 'Banner de Consentimento', 'cpw-consentimento' ); ?>:
                        <strong><?php echo $plugin_enabled ? esc_html__( 'Ativo', 'cpw-consentimento' ) : esc_html__( 'Inativo', 'cpw-consentimento' ); ?></strong>
                    </li>
                    <li>
                        <span class="cpw-status-icon <?php echo $gcm_enabled ? 'cpw-status-ok' : 'cpw-status-warn'; ?>"></span>
                        <?php esc_html_e( 'Google Consent Mode v2', 'cpw-consentimento' ); ?>:
                        <strong><?php echo $gcm_enabled ? esc_html__( 'Ativo', 'cpw-consentimento' ) : esc_html__( 'Inativo', 'cpw-consentimento' ); ?></strong>
                    </li>
                    <li>
                        <span class="cpw-status-icon <?php echo ! empty( $gtm_id ) ? 'cpw-status-ok' : 'cpw-status-warn'; ?>"></span>
                        <?php esc_html_e( 'Google Tag Manager', 'cpw-consentimento' ); ?>:
                        <strong><?php echo ! empty( $gtm_id ) ? esc_html( $gtm_id ) : esc_html__( 'Não configurado', 'cpw-consentimento' ); ?></strong>
                    </li>
                    <li>
                        <span class="cpw-status-icon <?php echo ! empty( $ga4_id ) ? 'cpw-status-ok' : 'cpw-status-warn'; ?>"></span>
                        <?php esc_html_e( 'Google Analytics 4', 'cpw-consentimento' ); ?>:
                        <strong><?php echo ! empty( $ga4_id ) ? esc_html( $ga4_id ) : esc_html__( 'Não configurado', 'cpw-consentimento' ); ?></strong>
                    </li>
                    <li>
                        <span class="cpw-status-icon <?php echo $dpo_set ? 'cpw-status-ok' : 'cpw-status-warn'; ?>"></span>
                        <?php esc_html_e( 'Encarregado (DPO)', 'cpw-consentimento' ); ?>:
                        <strong><?php echo $dpo_set ? esc_html__( 'Configurado', 'cpw-consentimento' ) : esc_html__( 'Não configurado', 'cpw-consentimento' ); ?></strong>
                    </li>
                </ul>
            </div>

            <div class="cpw-admin-box">
                <h3><?php esc_html_e( 'Navegação Rápida', 'cpw-consentimento' ); ?></h3>
                <ul>
                    <li><a href="<?php echo esc_url( admin_url( 'admin.php?page=cpw-consentimento-google' ) ); ?>"><?php esc_html_e( 'Configurar Google Consent Mode', 'cpw-consentimento' ); ?></a></li>
                    <li><a href="<?php echo esc_url( admin_url( 'admin.php?page=cpw-consentimento-banner' ) ); ?>"><?php esc_html_e( 'Personalizar Banner', 'cpw-consentimento' ); ?></a></li>
                    <li><a href="<?php echo esc_url( admin_url( 'admin.php?page=cpw-consentimento-privacy' ) ); ?>"><?php esc_html_e( 'Configurar Política de Privacidade', 'cpw-consentimento' ); ?></a></li>
                    <li><a href="<?php echo esc_url( admin_url( 'admin.php?page=cpw-consentimento-logs' ) ); ?>"><?php esc_html_e( 'Ver Registros de Consentimento', 'cpw-consentimento' ); ?></a></li>
                </ul>
            </div>

            <div class="cpw-admin-box cpw-lgpd-box">
                <h3><?php esc_html_e( 'Conformidade LGPD', 'cpw-consentimento' ); ?></h3>
                <p><?php esc_html_e( 'Este plugin foi desenvolvido para auxiliar na conformidade com a Lei Geral de Proteção de Dados (Lei nº 13.709/2018).', 'cpw-consentimento' ); ?></p>
                <p><strong><?php esc_html_e( 'Atenção:', 'cpw-consentimento' ); ?></strong> <?php esc_html_e( 'O uso deste plugin não garante conformidade legal completa. Consulte um advogado especializado em proteção de dados.', 'cpw-consentimento' ); ?></p>
            </div>
        </div>
    </div>
</div>
