<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap cpw-admin-wrap">
    <div class="cpw-admin-header">
        <h1><span class="dashicons dashicons-shield"></span> <?php esc_html_e( 'Política de Privacidade e LGPD', 'cpw-consentimento' ); ?></h1>
        <p class="cpw-admin-subtitle"><?php esc_html_e( 'Configure as informações de conformidade com a LGPD (Lei Geral de Proteção de Dados - Lei nº 13.709/2018).', 'cpw-consentimento' ); ?></p>
    </div>

    <?php settings_errors(); ?>

    <div class="cpw-admin-content">
        <div class="cpw-admin-main">
            <form method="post" action="options.php">
                <?php
                settings_fields( 'cpw_privacy_options' );
                do_settings_sections( 'cpw-consentimento-privacy' );
                submit_button( __( 'Salvar Configurações', 'cpw-consentimento' ) );
                ?>
            </form>
        </div>

        <div class="cpw-admin-sidebar">
            <div class="cpw-admin-box cpw-lgpd-box">
                <h3><?php esc_html_e( 'Direitos dos Titulares (LGPD)', 'cpw-consentimento' ); ?></h3>
                <p><?php esc_html_e( 'Conforme a LGPD, os titulares de dados têm os seguintes direitos:', 'cpw-consentimento' ); ?></p>
                <ul>
                    <li><?php esc_html_e( 'Confirmação de tratamento de dados', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Acesso aos dados', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Correção de dados incompletos ou desatualizados', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Anonimização, bloqueio ou eliminação de dados', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Portabilidade dos dados', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Eliminação dos dados tratados com consentimento', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Informação sobre compartilhamento', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Revogação do consentimento', 'cpw-consentimento' ); ?></li>
                </ul>
            </div>

            <div class="cpw-admin-box">
                <h3><?php esc_html_e( 'Obrigações do Controlador', 'cpw-consentimento' ); ?></h3>
                <p><?php esc_html_e( 'Como controlador de dados, sua empresa deve:', 'cpw-consentimento' ); ?></p>
                <ul>
                    <li><?php esc_html_e( 'Nomear um Encarregado (DPO)', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Manter registro das atividades de tratamento', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Implementar medidas de segurança', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Notificar incidentes à ANPD', 'cpw-consentimento' ); ?></li>
                    <li><?php esc_html_e( 'Obter consentimento explícito quando necessário', 'cpw-consentimento' ); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>
