<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap cpw-admin-wrap">
    <div class="cpw-admin-header">
        <h1><span class="dashicons dashicons-google"></span> <?php esc_html_e( 'Google Consent Mode v2', 'cpw-consentimento' ); ?></h1>
        <p class="cpw-admin-subtitle"><?php esc_html_e( 'Configure a integração com o Google Consent Mode v2 para que as tags do Google respeitem as escolhas de consentimento dos usuários.', 'cpw-consentimento' ); ?></p>
    </div>

    <?php settings_errors(); ?>

    <div class="cpw-admin-content">
        <div class="cpw-admin-main">
            <form method="post" action="options.php">
                <?php
                settings_fields( 'cpw_google_options' );
                do_settings_sections( 'cpw-consentimento-google' );
                submit_button( __( 'Salvar Configurações', 'cpw-consentimento' ) );
                ?>
            </form>
        </div>

        <div class="cpw-admin-sidebar">
            <div class="cpw-admin-box">
                <h3><?php esc_html_e( 'O que é o Google Consent Mode v2?', 'cpw-consentimento' ); ?></h3>
                <p><?php esc_html_e( 'O Google Consent Mode v2 é um framework que permite comunicar as preferências de consentimento dos visitantes às ferramentas do Google (Analytics, Ads, etc.).', 'cpw-consentimento' ); ?></p>
                <p><?php esc_html_e( 'Com ele, as tags do Google ajustam seu comportamento com base no status de consentimento, garantindo conformidade com leis de privacidade como a LGPD.', 'cpw-consentimento' ); ?></p>
            </div>

            <div class="cpw-admin-box">
                <h3><?php esc_html_e( 'Parâmetros do Consent Mode', 'cpw-consentimento' ); ?></h3>
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Parâmetro', 'cpw-consentimento' ); ?></th>
                            <th><?php esc_html_e( 'Descrição', 'cpw-consentimento' ); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>analytics_storage</code></td>
                            <td><?php esc_html_e( 'Controla o armazenamento de dados de analytics (ex: GA4)', 'cpw-consentimento' ); ?></td>
                        </tr>
                        <tr>
                            <td><code>ad_storage</code></td>
                            <td><?php esc_html_e( 'Controla o armazenamento de cookies de publicidade', 'cpw-consentimento' ); ?></td>
                        </tr>
                        <tr>
                            <td><code>ad_user_data</code></td>
                            <td><?php esc_html_e( 'Controla o envio de dados de usuário para publicidade', 'cpw-consentimento' ); ?></td>
                        </tr>
                        <tr>
                            <td><code>ad_personalization</code></td>
                            <td><?php esc_html_e( 'Controla a personalização de anúncios', 'cpw-consentimento' ); ?></td>
                        </tr>
                        <tr>
                            <td><code>functionality_storage</code></td>
                            <td><?php esc_html_e( 'Controla cookies de funcionalidade do site', 'cpw-consentimento' ); ?></td>
                        </tr>
                        <tr>
                            <td><code>security_storage</code></td>
                            <td><?php esc_html_e( 'Controla cookies de segurança', 'cpw-consentimento' ); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
