<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

global $wpdb;
$table_name = $wpdb->prefix . 'cpw_consent_logs';

// Paginação
$per_page    = 20;
$current_page = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;
$offset      = ( $current_page - 1 ) * $per_page;

$total_items = $wpdb->get_var( "SELECT COUNT(*) FROM {$table_name}" );
$logs        = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM {$table_name} ORDER BY created_at DESC LIMIT %d OFFSET %d", $per_page, $offset ) );
$total_pages = ceil( $total_items / $per_page );
?>
<div class="wrap cpw-admin-wrap">
    <div class="cpw-admin-header">
        <h1><span class="dashicons dashicons-list-view"></span> <?php esc_html_e( 'Registros de Consentimento', 'cpw-consentimento' ); ?></h1>
        <p class="cpw-admin-subtitle"><?php esc_html_e( 'Histórico de consentimentos registrados para fins de auditoria e conformidade com a LGPD.', 'cpw-consentimento' ); ?></p>
    </div>

    <div class="cpw-admin-content cpw-full-width">
        <div class="tablenav top">
            <div class="alignleft actions">
                <span class="displaying-num">
                    <?php printf( esc_html__( '%d registros', 'cpw-consentimento' ), intval( $total_items ) ); ?>
                </span>
            </div>
        </div>

        <?php if ( $logs ) : ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'ID', 'cpw-consentimento' ); ?></th>
                    <th><?php esc_html_e( 'IP do Usuário', 'cpw-consentimento' ); ?></th>
                    <th><?php esc_html_e( 'Status', 'cpw-consentimento' ); ?></th>
                    <th><?php esc_html_e( 'Analytics', 'cpw-consentimento' ); ?></th>
                    <th><?php esc_html_e( 'Publicidade', 'cpw-consentimento' ); ?></th>
                    <th><?php esc_html_e( 'Funcionalidade', 'cpw-consentimento' ); ?></th>
                    <th><?php esc_html_e( 'User Agent', 'cpw-consentimento' ); ?></th>
                    <th><?php esc_html_e( 'Data/Hora', 'cpw-consentimento' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ( $logs as $log ) : ?>
                <tr>
                    <td><?php echo esc_html( $log->id ); ?></td>
                    <td><?php echo esc_html( $log->ip_address ); ?></td>
                    <td>
                        <span class="cpw-status-badge cpw-status-<?php echo esc_attr( $log->consent_status ); ?>">
                            <?php echo esc_html( $log->consent_status === 'granted' ? __( 'Aceito', 'cpw-consentimento' ) : __( 'Recusado', 'cpw-consentimento' ) ); ?>
                        </span>
                    </td>
                    <td><?php echo esc_html( $log->analytics_storage ); ?></td>
                    <td><?php echo esc_html( $log->ad_storage ); ?></td>
                    <td><?php echo esc_html( $log->functionality_storage ); ?></td>
                    <td><span title="<?php echo esc_attr( $log->user_agent ); ?>"><?php echo esc_html( substr( $log->user_agent, 0, 50 ) . '...' ); ?></span></td>
                    <td><?php echo esc_html( $log->created_at ); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <?php if ( $total_pages > 1 ) : ?>
        <div class="tablenav bottom">
            <div class="tablenav-pages">
                <?php
                echo paginate_links( array(
                    'base'      => add_query_arg( 'paged', '%#%' ),
                    'format'    => '',
                    'prev_text' => '&laquo;',
                    'next_text' => '&raquo;',
                    'total'     => $total_pages,
                    'current'   => $current_page
                ) );
                ?>
            </div>
        </div>
        <?php endif; ?>

        <?php else : ?>
        <div class="cpw-admin-box">
            <p><?php esc_html_e( 'Nenhum registro de consentimento encontrado. Os registros aparecerão aqui quando os usuários interagirem com o banner de consentimento.', 'cpw-consentimento' ); ?></p>
            <?php
            $privacy_options = get_option( 'cpw_privacy_options', array() );
            if ( empty( $privacy_options['enable_consent_log'] ) ) :
            ?>
            <p><strong><?php esc_html_e( 'Atenção:', 'cpw-consentimento' ); ?></strong> <?php esc_html_e( 'O registro de consentimentos está desativado. Ative-o nas', 'cpw-consentimento' ); ?> <a href="<?php echo esc_url( admin_url( 'admin.php?page=cpw-consentimento-privacy' ) ); ?>"><?php esc_html_e( 'configurações de privacidade', 'cpw-consentimento' ); ?></a>.</p>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</div>
