<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap cpw-admin-wrap">
    <div class="cpw-admin-header">
        <h1><span class="dashicons dashicons-admin-appearance"></span> <?php esc_html_e( 'Aparência do Banner', 'cpw-consentimento' ); ?></h1>
        <p class="cpw-admin-subtitle"><?php esc_html_e( 'Personalize a aparência e o texto do banner de consentimento de cookies.', 'cpw-consentimento' ); ?></p>
    </div>

    <?php settings_errors(); ?>

    <div class="cpw-admin-content">
        <div class="cpw-admin-main">
            <form method="post" action="options.php">
                <?php
                settings_fields( 'cpw_banner_options' );
                do_settings_sections( 'cpw-consentimento-banner' );
                submit_button( __( 'Salvar Configurações', 'cpw-consentimento' ) );
                ?>
            </form>
        </div>

        <div class="cpw-admin-sidebar">
            <div class="cpw-admin-box">
                <h3><?php esc_html_e( 'Pré-visualização do Banner', 'cpw-consentimento' ); ?></h3>
                <?php
                $banner_options = get_option( 'cpw_banner_options', array() );
                $bg_color       = ! empty( $banner_options['banner_bg_color'] ) ? $banner_options['banner_bg_color'] : '#ffffff';
                $text_color     = ! empty( $banner_options['banner_text_color'] ) ? $banner_options['banner_text_color'] : '#333333';
                $accept_color   = ! empty( $banner_options['banner_accept_btn_color'] ) ? $banner_options['banner_accept_btn_color'] : '#0073aa';
                $decline_color  = ! empty( $banner_options['banner_decline_btn_color'] ) ? $banner_options['banner_decline_btn_color'] : '#666666';
                $title          = ! empty( $banner_options['banner_title'] ) ? $banner_options['banner_title'] : __( 'Sua privacidade é importante para nós', 'cpw-consentimento' );
                $text           = ! empty( $banner_options['banner_text'] ) ? $banner_options['banner_text'] : __( 'Utilizamos cookies para melhorar a sua experiência.', 'cpw-consentimento' );
                $accept_text    = ! empty( $banner_options['accept_btn_text'] ) ? $banner_options['accept_btn_text'] : __( 'Aceitar todos', 'cpw-consentimento' );
                $decline_text   = ! empty( $banner_options['decline_btn_text'] ) ? $banner_options['decline_btn_text'] : __( 'Recusar', 'cpw-consentimento' );
                $custom_text    = ! empty( $banner_options['customize_btn_text'] ) ? $banner_options['customize_btn_text'] : __( 'Personalizar', 'cpw-consentimento' );
                ?>
                <div class="cpw-banner-preview" style="background-color: <?php echo esc_attr( $bg_color ); ?>; color: <?php echo esc_attr( $text_color ); ?>; padding: 20px; border-radius: 4px; border: 1px solid #ddd;">
                    <h4 style="margin-top: 0; color: <?php echo esc_attr( $text_color ); ?>;"><?php echo esc_html( $title ); ?></h4>
                    <p style="color: <?php echo esc_attr( $text_color ); ?>;"><?php echo esc_html( $text ); ?></p>
                    <div>
                        <button style="background-color: <?php echo esc_attr( $accept_color ); ?>; color: #fff; border: none; padding: 8px 16px; cursor: pointer; margin-right: 8px; border-radius: 3px;"><?php echo esc_html( $accept_text ); ?></button>
                        <button style="background-color: <?php echo esc_attr( $decline_color ); ?>; color: #fff; border: none; padding: 8px 16px; cursor: pointer; margin-right: 8px; border-radius: 3px;"><?php echo esc_html( $decline_text ); ?></button>
                        <button style="background-color: transparent; color: <?php echo esc_attr( $text_color ); ?>; border: 1px solid <?php echo esc_attr( $text_color ); ?>; padding: 8px 16px; cursor: pointer; border-radius: 3px;"><?php echo esc_html( $custom_text ); ?></button>
                    </div>
                </div>
                <p class="description"><?php esc_html_e( 'Salve as configurações para atualizar a pré-visualização.', 'cpw-consentimento' ); ?></p>
            </div>
        </div>
    </div>
</div>
