/* ==========================================================================
   CPW Consentimento - Scripts do Painel Administrativo
   ========================================================================== */

(function( $ ) {
    'use strict';

    $(document).ready(function() {

        // Inicializar o color picker
        if ( $.fn.wpColorPicker ) {
            $('.cpw-color-picker').wpColorPicker({
                change: function( event, ui ) {
                    updateBannerPreview();
                },
                clear: function() {
                    updateBannerPreview();
                }
            });
        }

        // Atualizar pré-visualização do banner ao digitar
        $('input[name*="banner_"], textarea[name*="banner_"]').on('input change', function() {
            updateBannerPreview();
        });

        // Função de pré-visualização do banner
        function updateBannerPreview() {
            var bgColor     = $('input[name="cpw_banner_options[banner_bg_color]"]').val() || '#ffffff';
            var textColor   = $('input[name="cpw_banner_options[banner_text_color]"]').val() || '#333333';
            var acceptColor = $('input[name="cpw_banner_options[banner_accept_btn_color]"]').val() || '#0073aa';
            var declineColor = $('input[name="cpw_banner_options[banner_decline_btn_color]"]').val() || '#666666';

            $('.cpw-banner-preview').css({
                'background-color': bgColor,
                'color': textColor
            });
        }

    });

})( jQuery );
