# CPW Consentimento

[![WordPress](https://img.shields.io/badge/WordPress-5.9%2B-blue)](https://wordpress.org)
[![PHP](https://img.shields.io/badge/PHP-7.4%2B-purple)](https://php.net)
[![License](https://img.shields.io/badge/License-GPL%20v2-green)](https://www.gnu.org/licenses/gpl-2.0.html)
[![Version](https://img.shields.io/badge/Version-1.0.0-orange)](https://github.com/pjoaoaraujo/cpw-consentimento)
[![LGPD](https://img.shields.io/badge/LGPD-Compliant-brightgreen)](https://www.planalto.gov.br/ccivil_03/_ato2015-2018/2018/lei/l13709.htm)

**Plugin WordPress para gerenciamento de consentimento de cookies com integração ao Google Consent Mode v2, em total conformidade com a LGPD (Lei Geral de Proteção de Dados).**

---

## Sumário

- [Sobre o Plugin](#sobre-o-plugin)
- [Funcionalidades](#funcionalidades)
- [Requisitos](#requisitos)
- [Instalação](#instalação)
- [Configuração](#configuração)
  - [Configurações Gerais](#configurações-gerais)
  - [Google Consent Mode v2](#google-consent-mode-v2)
  - [Aparência do Banner](#aparência-do-banner)
  - [Política de Privacidade e LGPD](#política-de-privacidade-e-lgpd)
  - [Registros de Consentimento](#registros-de-consentimento)
- [Integração com Google Consent Mode v2](#integração-com-google-consent-mode-v2)
- [Conformidade com a LGPD](#conformidade-com-a-lgpd)
- [API JavaScript](#api-javascript)
- [Hooks e Filtros](#hooks-e-filtros)
- [Estrutura de Arquivos](#estrutura-de-arquivos)
- [Banco de Dados](#banco-de-dados)
- [Perguntas Frequentes](#perguntas-frequentes)
- [Changelog](#changelog)
- [Contribuição](#contribuição)
- [Licença](#licença)

---

## Sobre o Plugin

O **CPW Consentimento** é um plugin WordPress desenvolvido para auxiliar proprietários de sites brasileiros a estarem em conformidade com a **Lei Geral de Proteção de Dados (LGPD — Lei nº 13.709/2018)**. Ele fornece um banner de consentimento de cookies totalmente personalizável e se integra nativamente com o **Google Consent Mode v2**, garantindo que as ferramentas do Google (Analytics, Ads, Tag Manager) respeitem as escolhas de privacidade dos usuários.

O plugin foi projetado seguindo as melhores práticas de desenvolvimento WordPress, com código limpo, seguro e extensível.

---

## Funcionalidades

### Banner de Consentimento
- Banner totalmente personalizável (cores, textos, posição)
- Cinco posições disponíveis: rodapé, cabeçalho, canto inferior esquerdo, canto inferior direito e modal central
- Modal de personalização granular de cookies por categoria
- Design responsivo para todos os dispositivos
- Animações suaves de entrada e saída
- Acessibilidade (ARIA labels, roles)

### Google Consent Mode v2
- Integração nativa com o **Google Consent Mode v2**
- Injeção automática do código de consentimento padrão no `<head>` (antes de qualquer tag)
- Suporte a todos os 6 parâmetros: `analytics_storage`, `ad_storage`, `ad_user_data`, `ad_personalization`, `functionality_storage`, `security_storage`
- Integração com **Google Tag Manager (GTM)**
- Integração com **Google Analytics 4 (GA4)**
- Restauração automática do consentimento salvo em visitas subsequentes

### Conformidade com a LGPD
- Consentimento explícito e granular por categoria de cookie
- Cookies de rastreamento bloqueados por padrão antes do consentimento
- Registro de consentimentos com anonimização de IP
- Campos para cadastro do **Encarregado (DPO)**
- Vinculação com a página de Política de Privacidade
- Direito de revogação de consentimento

### Painel Administrativo
- Dashboard com status em tempo real do plugin
- Cinco seções de configuração organizadas
- Pré-visualização do banner em tempo real
- Tabela de registros de consentimento com paginação
- Interface familiar ao padrão do WordPress

---

## Requisitos

| Requisito | Versão Mínima |
|-----------|--------------|
| WordPress | 5.9 |
| PHP | 7.4 |
| MySQL | 5.6 |

**Dependências obrigatórias:**
- Kit do Site do Google (Google Site Kit) **ou** configuração manual do GTM/GA4 nas configurações do plugin.

---

## Instalação

### Método 1: Upload via Painel WordPress

1. Acesse o painel de administração do WordPress.
2. Navegue até **Plugins > Adicionar novo**.
3. Clique em **Enviar plugin** no topo da página.
4. Selecione o arquivo `.zip` do plugin e clique em **Instalar agora**.
5. Após a instalação, clique em **Ativar plugin**.

### Método 2: Upload via FTP

1. Extraia o arquivo `.zip` do plugin.
2. Faça o upload da pasta `cpw-consentimento` para o diretório `/wp-content/plugins/` do seu servidor.
3. Acesse o painel de administração do WordPress.
4. Navegue até **Plugins** e ative o **CPW Consentimento**.

### Método 3: Clonar via Git

```bash
cd /caminho/para/wp-content/plugins/
git clone https://github.com/pjoaoaraujo/cpw-consentimento.git cpw-consentimento
```

Após a clonagem, ative o plugin pelo painel de administração do WordPress.

---

## Configuração

Após a ativação, um novo item de menu chamado **CPW Consentimento** aparecerá no painel de administração do WordPress.

### Configurações Gerais

Acesse **CPW Consentimento > Configurações Gerais** para:

| Campo | Descrição | Padrão |
|-------|-----------|--------|
| Ativar Plugin | Habilita/desabilita o banner de consentimento | Ativado |
| Duração do Cookie | Quantos dias o consentimento é armazenado | 365 dias |
| Nome do Cookie | Nome do cookie de consentimento | `cpw_consent_status` |
| Bloquear Scripts | Bloqueia scripts de rastreamento antes do consentimento | Ativado |

### Google Consent Mode v2

Acesse **CPW Consentimento > Google Consent Mode** para:

| Campo | Descrição |
|-------|-----------|
| Ativar Google Consent Mode v2 | Habilita a integração |
| ID do Google Tag Manager | ID do contêiner GTM (ex: `GTM-XXXXXXX`) |
| ID do Google Analytics 4 | ID de medição GA4 (ex: `G-XXXXXXXXXX`) |
| Padrão: analytics_storage | Estado padrão para analytics (recomendado: `denied`) |
| Padrão: ad_storage | Estado padrão para publicidade (recomendado: `denied`) |
| Padrão: ad_user_data | Estado padrão para dados de usuário (recomendado: `denied`) |
| Padrão: ad_personalization | Estado padrão para personalização (recomendado: `denied`) |
| Padrão: functionality_storage | Estado padrão para funcionalidade (recomendado: `granted`) |
| Padrão: security_storage | Estado padrão para segurança (recomendado: `granted`) |

> **Importante:** Para conformidade com a LGPD, todos os parâmetros de rastreamento devem ser definidos como `denied` por padrão.

### Aparência do Banner

Acesse **CPW Consentimento > Aparência do Banner** para personalizar:

- Título e texto do banner
- Posição do banner (rodapé, cabeçalho, cantos, modal)
- Cores de fundo, texto e botões
- Textos dos botões (Aceitar, Recusar, Personalizar)

### Política de Privacidade e LGPD

Acesse **CPW Consentimento > Política de Privacidade** para configurar:

- Página de Política de Privacidade (vinculação)
- Nome e e-mail do Encarregado (DPO)
- Nome e CNPJ da empresa
- Ativação do registro de consentimentos

### Registros de Consentimento

Acesse **CPW Consentimento > Registros de Consentimento** para visualizar o histórico de consentimentos com:

- IP anonimizado do usuário
- Status do consentimento
- Detalhes por categoria (analytics, publicidade, funcionalidade)
- User Agent do navegador
- Data e hora do consentimento

---

## Integração com Google Consent Mode v2

O plugin injeta automaticamente o código do Google Consent Mode v2 no `<head>` da página, **antes** de qualquer tag do Google, conforme exigido pela documentação oficial do Google.

### Fluxo de Funcionamento

```
1. Página carrega
2. CPW injeta gtag('consent', 'default', {...}) com todos os parâmetros como 'denied'
3. Se o usuário já consentiu anteriormente, restaura o estado salvo
4. GTM/GA4 é carregado (respeitando os estados de consentimento)
5. Banner é exibido (se necessário)
6. Usuário interage com o banner
7. CPW atualiza: gtag('consent', 'update', {...})
8. Tags do Google ajustam seu comportamento
9. Consentimento é salvo em cookie e registrado no banco de dados
```

### Exemplo de Código Gerado

```html
<script>
window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}

gtag('consent', 'default', {
    'analytics_storage':      'denied',
    'ad_storage':             'denied',
    'ad_user_data':           'denied',
    'ad_personalization':     'denied',
    'functionality_storage':  'granted',
    'security_storage':       'granted',
    'personalization_storage': 'denied',
    'wait_for_update': 500
});
</script>
```

---

## Conformidade com a LGPD

O CPW Consentimento foi desenvolvido para auxiliar na conformidade com os seguintes artigos da LGPD:

| Artigo | Requisito | Implementação |
|--------|-----------|---------------|
| Art. 5º, XII | Consentimento livre, informado e inequívoco | Banner com opções claras de aceitar/recusar/personalizar |
| Art. 7º, I | Base legal: consentimento | Registro do consentimento com data e hora |
| Art. 8º | Requisitos do consentimento | Consentimento explícito, não presumido |
| Art. 9º | Direito de acesso | Link para Política de Privacidade |
| Art. 15 | Término do tratamento | Opção de revogar consentimento |
| Art. 18 | Direitos do titular | Informações sobre DPO e contato |
| Art. 41 | Encarregado (DPO) | Campo para cadastro do DPO |

> **Aviso Legal:** Este plugin é uma ferramenta de auxílio técnico. O uso deste plugin não garante conformidade legal completa com a LGPD. Recomendamos consultar um advogado especializado em proteção de dados para uma avaliação completa da conformidade da sua organização.

---

## API JavaScript

O plugin expõe uma API JavaScript pública para integração com outros scripts:

```javascript
// Aceitar todos os cookies programaticamente
window.CPWConsent.acceptAll();

// Recusar todos os cookies opcionais
window.CPWConsent.declineAll();

// Abrir o modal de personalização
window.CPWConsent.openCustomizeModal();

// Verificar o status do consentimento
var status = window.CPWConsent.getCookie('cpw_consent_status');
// Retorna: 'granted', 'denied', 'partial' ou null (não definido)

// Obter os dados detalhados de consentimento
var data = JSON.parse(window.CPWConsent.getCookie('cpw_consent_data') || '{}');
```

### Evento Customizado

O plugin dispara um evento jQuery quando o consentimento é atualizado:

```javascript
$(document).on('cpw_consent_updated', function(event, consentData) {
    console.log('Consentimento atualizado:', consentData);
    // consentData contém todos os parâmetros do Google Consent Mode
});
```

### Link para Abrir Configurações

Adicione a classe `cpw-open-consent-settings` a qualquer link para abrir o modal de configurações de cookies:

```html
<a href="#" class="cpw-open-consent-settings">Gerenciar cookies</a>
```

---

## Hooks e Filtros

### Actions

```php
// Executado após o registro do consentimento
do_action('cpw_consent_logged', $consent_status, $consent_data);

// Executado antes de exibir o banner
do_action('cpw_before_banner');

// Executado após exibir o banner
do_action('cpw_after_banner');
```

### Filters

```php
// Modificar os dados passados para o JavaScript
add_filter('cpw_localize_script_data', function($data) {
    $data['customField'] = 'valor';
    return $data;
});

// Modificar o HTML do banner
add_filter('cpw_banner_html', function($html) {
    return $html;
});

// Modificar as categorias de cookies no modal
add_filter('cpw_cookie_categories', function($categories) {
    $categories['marketing'] = array(
        'title'       => 'Marketing',
        'description' => 'Cookies de marketing personalizados.',
        'required'    => false,
    );
    return $categories;
});
```

---

## Estrutura de Arquivos

```
cpw-consentimento/
├── cpw-consentimento.php          # Arquivo principal do plugin
├── uninstall.php                  # Rotinas de desinstalação
├── README.md                      # Documentação
├── LICENSE                        # Licença GPL v2
├── .gitignore                     # Arquivos ignorados pelo Git
│
├── includes/                      # Classes PHP principais
│   ├── class-cpw-consentimento.php  # Classe principal (orquestrador)
│   ├── class-cpw-loader.php         # Gerenciador de hooks
│   ├── class-cpw-activator.php      # Rotinas de ativação
│   └── class-cpw-deactivator.php    # Rotinas de desativação
│
├── admin/                         # Código do painel administrativo
│   ├── class-cpw-admin.php          # Classe de administração
│   ├── css/
│   │   └── admin-style.css          # Estilos do painel admin
│   ├── js/
│   │   └── admin-script.js          # Scripts do painel admin
│   └── partials/                    # Templates PHP do admin
│       ├── settings-page.php        # Página de configurações gerais
│       ├── google-settings-page.php # Página do Google Consent Mode
│       ├── banner-settings-page.php # Página de aparência do banner
│       ├── privacy-settings-page.php # Página de privacidade/LGPD
│       └── consent-logs-page.php    # Página de registros
│
├── public/                        # Código do frontend
│   ├── class-cpw-public.php         # Classe pública
│   ├── css/
│   │   └── consent-banner.css       # Estilos do banner
│   ├── js/
│   │   └── consent-banner.js        # Scripts do banner
│   └── partials/
│       └── banner.php               # Template HTML do banner
│
└── languages/                     # Arquivos de internacionalização
    └── cpw-consentimento.pot        # Template de tradução
```

---

## Banco de Dados

O plugin cria uma tabela no banco de dados para registrar os consentimentos:

### Tabela: `{prefix}_cpw_consent_logs`

| Coluna | Tipo | Descrição |
|--------|------|-----------|
| `id` | BIGINT(20) | Identificador único (auto-incremento) |
| `ip_address` | VARCHAR(45) | IP anonimizado do usuário (último octeto zerado) |
| `consent_status` | VARCHAR(20) | Status geral: `granted`, `denied`, `partial` |
| `analytics_storage` | VARCHAR(10) | Status do analytics: `granted` ou `denied` |
| `ad_storage` | VARCHAR(10) | Status da publicidade: `granted` ou `denied` |
| `functionality_storage` | VARCHAR(10) | Status da funcionalidade: `granted` ou `denied` |
| `user_agent` | TEXT | User agent do navegador |
| `created_at` | DATETIME | Data e hora do consentimento |

> **Nota sobre privacidade:** O último octeto do endereço IP é zerado antes do armazenamento (ex: `192.168.1.100` → `192.168.1.0`), garantindo a anonimização conforme recomendado pela LGPD.

---

## Perguntas Frequentes

**O plugin é compatível com o Google Site Kit?**

Sim. O CPW Consentimento é projetado para funcionar em conjunto com o Google Site Kit. Configure o ID do GTM ou GA4 nas configurações do plugin para que o Google Consent Mode seja injetado antes das tags do Site Kit.

**O plugin garante conformidade total com a LGPD?**

O plugin fornece as ferramentas técnicas necessárias para auxiliar na conformidade. No entanto, a conformidade legal completa depende também de políticas organizacionais, contratos com fornecedores e outros fatores. Recomendamos consultar um advogado especializado.

**O plugin funciona com cache de página?**

Sim. O banner é renderizado via PHP no servidor e os estados de consentimento são gerenciados via cookies no lado do cliente, sendo compatível com a maioria dos plugins de cache.

**Posso personalizar as categorias de cookies?**

Sim, através do filtro `cpw_cookie_categories` você pode adicionar categorias personalizadas ao modal de preferências.

**O plugin afeta o desempenho do site?**

O plugin foi otimizado para impacto mínimo no desempenho. Os scripts e estilos são carregados apenas quando necessário, e o código do Google Consent Mode é injetado de forma assíncrona.

---

## Changelog

### 1.0.0 — 2024
- Lançamento inicial do plugin
- Integração com Google Consent Mode v2
- Suporte a Google Tag Manager e Google Analytics 4
- Banner de consentimento personalizável com 5 posições
- Modal de preferências granulares por categoria
- Painel administrativo completo com 5 seções
- Registro de consentimentos com anonimização de IP
- Conformidade com a LGPD (Lei nº 13.709/2018)
- Suporte a internacionalização (i18n)
- API JavaScript pública

---

## Contribuição

Contribuições são bem-vindas! Para contribuir:

1. Faça um fork do repositório
2. Crie uma branch para sua feature: `git checkout -b feature/minha-feature`
3. Faça commit das suas alterações: `git commit -m 'Adiciona minha feature'`
4. Faça push para a branch: `git push origin feature/minha-feature`
5. Abra um Pull Request

### Reportar Bugs

Abra uma [issue no GitHub](https://github.com/pjoaoaraujo/cpw-consentimento/issues) com:
- Versão do WordPress
- Versão do PHP
- Descrição detalhada do problema
- Passos para reproduzir

---

## Licença

Este plugin é licenciado sob a **GNU General Public License v2.0 ou posterior**.

```
CPW Consentimento - Plugin WordPress para conformidade com LGPD
Copyright (C) 2026 CPW

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
```

Veja o arquivo [LICENSE](LICENSE) para o texto completo da licença.

---

**Desenvolvido por [CPW](https://criandoparaweb.com.br/wordpress) com ❤️ para a comunidade WordPress brasileira.**
